package com.example.sefinsa_app.ui.clientes.documentos;

import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.ortiz.touchview.TouchImageView;
import com.squareup.picasso.MemoryPolicy;
import com.squareup.picasso.NetworkPolicy;
import com.squareup.picasso.Picasso;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientesDocumentosFragment extends Fragment {

    private ClientesDocumentosViewModel mViewModel;
    private TextView tvCliente, tvAval;
    private Cliente cliente;
    private String clienteId;
    private LinearLayoutCompat comprobantesCliente, garantiasCliente, comprobantesAval, garantiasAval;
    private VolleyS vs;
    private RequestQueue requestQueue;
    int maxRetries = 3; // Puedes cambiar este número si deseas más o menos reintentos
    int maxRetriesAval = 3;

    public static ClientesDocumentosFragment newInstance() {
        return new ClientesDocumentosFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        setHasOptionsMenu(true);
        return inflater.inflate(R.layout.fragment_clientes_documentos, container, false);

    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                getFiles("comprobantes/clientes/" + cliente.getId() + "_" + cliente.getNombre_completo().toUpperCase(), comprobantesCliente);
                getFiles("garantias/clientes/" + cliente.getId() + "_" + cliente.getNombre_completo().toUpperCase(), garantiasCliente);
                getFiles("comprobantes/avales/" + cliente.getAval_id() + "_" + cliente.getNombre_aval().toUpperCase(), comprobantesAval);
                getFiles("garantias/avales/" + cliente.getAval_id() + "_" + cliente.getNombre_aval().toUpperCase(), garantiasAval);
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        initElements(view);

        getFiles("comprobantes/clientes/" + clienteId + "_" + cliente.getNombre_completo().toUpperCase(), comprobantesCliente);
        getFiles("garantias/clientes/" + clienteId + "_" + cliente.getNombre_completo().toUpperCase(), garantiasCliente);
        getFilesA("comprobantes/avales/" + cliente.getAval_id() + "_" + cliente.getNombre_aval().toUpperCase(), comprobantesAval);
        getFilesA("garantias/avales/" + cliente.getAval_id() + "_" + cliente.getNombre_aval().toUpperCase(), garantiasAval);

        Log.d("DEBUG1", "ARREGLO EN CLIENTES DOCUMENTOS................" + cliente.toString());
        Log.d("DEBUG1", String.valueOf(cliente));
        Log.d("DEBUG2", clienteId);
        Log.d("DEBUG2", "ID de aval en DocumentosClientes................" + cliente.getAval_id());
    }

    public void initElements(View view) {

        CurrentFragment.fragment = "ClientesDocumentosFragment";

        Bundle args = getArguments();
        String personJsonString = args.getString("cliente");
        String personJsonString3 = args.getString("clienteId");
        cliente = Utils.getGsonParser().fromJson(personJsonString, Cliente.class);
        Log.e("Error", "Archivo cliente.........................: " + cliente.toString());
        clienteId = personJsonString3;
        tvCliente = view.findViewById(R.id.tvCliente);
        tvCliente.setText("EXPEDIENTE DE: \n" + cliente.getNombre_completo());

        tvAval = view.findViewById(R.id.tvAval);
        tvAval.setText("AVAL: \n" + cliente.getNombre_aval());

        comprobantesCliente = view.findViewById(R.id.comprobantesCliente);
        garantiasCliente = view.findViewById(R.id.garantiasCliente);
        comprobantesAval = view.findViewById(R.id.comprobantesAval);
        garantiasAval = view.findViewById(R.id.garantiasAval);
    }

    private void checkIfImageExists(String url, Runnable onSuccess, Runnable onFailure) {
        StringRequest headRequest = new StringRequest(Request.Method.HEAD, url,
                response -> onSuccess.run(),  // La imagen existe
                error -> onFailure.run()      // La imagen no existe
        );
        requestQueue.add(headRequest);
    }

    public void getFiles(String carpeta, LinearLayoutCompat contenedor) {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        String path = API.url.replace("php/", "resources/");
        //String path = "https://sw.gruposefinsa.com/resources/";
        //String path = "https://gruposefinsa.com/test/resources/";
        String ruta = "../../resources/" + carpeta;
        Log.d("ruta", "RUTA COMPLETA............:" + ruta);

        JSONObject data = new JSONObject();
        try {
            data.put("func", "archivos");
            data.put("ruta", ruta);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        Log.d("4", "loadAllData: ");

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            dialog.cancel();
                            Log.d("data", String.valueOf(data));

                            if (!response.get("data").toString().equals("false")) {
                                JSONArray jsonArray = (JSONArray) response.get("data");
                                Log.d("archivos", jsonArray.length() + "");

                                // Crear una lista para almacenar los nombres de archivo
                                List<String> fileNames = new ArrayList<>();

                                for (int i = 2; i < jsonArray.length(); i++) {
                                    String fileName = jsonArray.getString(i);
                                    if (fileName.endsWith("9Expediente") || fileName.endsWith("9Thumbnail")) {
                                        Log.d("OMITIR", "Archivo omitido porque termina en 'T' o es una subcarpeta: " + fileName);
                                        continue; // Pasar al siguiente archivo
                                    }
                                    fileNames.add(fileName);
                                }

                                // Mostrar imágenes una por una
                                showImageSequentially(fileNames, 0, path, contenedor, carpeta);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, getActivity());
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    private void showImageSequentially(List<String> fileNames, int index, String path, LinearLayoutCompat contenedor, String carpeta) {
        if (index >= fileNames.size()) return; // Salir si se ha mostrado todas las imágenes

        DisplayMetrics displayMetrics = new DisplayMetrics();
        getActivity().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int windowWidth = displayMetrics.widthPixels;

        float percentage = 0.85f;
        int calculatedWidth = (int) (windowWidth * percentage);
        String fileName = fileNames.get(index);

        // Crear el ImageView
        ImageView image = new ImageView(getActivity());
        String imageUrl = path + carpeta + "/" + fileName;

        String fileNameConE = "";
        if (fileName.contains(".")) {
            fileNameConE = fileName.substring(0, fileName.lastIndexOf(".")) + "E" + fileName.substring(fileName.lastIndexOf("."));
        } else {
            fileNameConE = fileName + "E";
        }

        String subcarpetaUrl = path + carpeta + "/9Expediente/" + fileNameConE;

        // Verifica solo la existencia de subcarpetaUrl
        checkIfImageExists(subcarpetaUrl, () -> {
            // Cargar la imagen desde subcarpetaUrl si existe
            Glide.with(getActivity())
                    .asBitmap()
                    .load(subcarpetaUrl)
                    .diskCacheStrategy(DiskCacheStrategy.NONE)
                    .skipMemoryCache(true)
                    .into(new SimpleTarget<Bitmap>() {
                        @Override
                        public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                            processImage(resource, calculatedWidth, contenedor, image, subcarpetaUrl);
                            new Handler(Looper.getMainLooper()).postDelayed(() -> showImageSequentially(fileNames, index + 1, path, contenedor, carpeta), 80);
                        }

                        @Override
                        public void onLoadFailed(@Nullable Drawable errorDrawable) {
                            Log.e("GlideError", "No se pudo cargar la imagen desde la URL: " + subcarpetaUrl);
                        }
                    });
        }, () -> {
            // Si no existe en subcarpetaUrl, cargar directamente desde imageUrl
            loadImageWithRetries(imageUrl, calculatedWidth, contenedor, image, fileNames, index, path, carpeta, maxRetries, 0);
        });
    }
    private void loadImageWithRetries(String imageUrl, int calculatedWidth, LinearLayoutCompat contenedor, ImageView image, List<String> fileNames, int index, String path, String carpeta, int maxRetries, int currentRetry) {
        if (getActivity() == null || !isAdded()) {
            Log.e("GlideError", "Fragmento no adjunto, cancelando carga de imagen.");
            return; // Salir de la función si el fragmento no está adjunto
        }

        Glide.with(this) // Usamos "this" en lugar de getActivity()
                .asBitmap()
                .load(imageUrl)
                .diskCacheStrategy(DiskCacheStrategy.NONE)
                .skipMemoryCache(true)
                .into(new SimpleTarget<Bitmap>() {
                    @Override
                    public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                        processImage(resource, calculatedWidth, contenedor, image, imageUrl);
                        new Handler(Looper.getMainLooper()).postDelayed(() -> showImageSequentially(fileNames, index + 1, path, contenedor, carpeta), 80);
                    }

                    @Override
                    public void onLoadFailed(@Nullable Drawable errorDrawable) {
                        Log.e("GlideError", "Fallo al cargar la imagen desde: " + imageUrl);
                        if (currentRetry < maxRetries) {
                            Log.d("GlideRetry", "Reintentando carga. Intento " + (currentRetry + 1) + " de " + maxRetries);
                            loadImageWithRetries(imageUrl, calculatedWidth, contenedor, image, fileNames, index, path, carpeta, maxRetries, currentRetry + 1);
                        } else {
                            Log.e("GlideError", "Todos los reintentos fallaron para la URL: " + imageUrl);
                        }
                    }
                });
    }


    private void loadImageWithRetriesAval(String imageUrl, int calculatedWidth, LinearLayoutCompat contenedor, ImageView image, List<String> fileNames, int index, String path, String carpeta, int maxRetries, int currentRetry) {
        Glide.with(getActivity())
                .asBitmap()
                .load(imageUrl)
                .diskCacheStrategy(DiskCacheStrategy.NONE)
                .skipMemoryCache(true)
                .into(new SimpleTarget<Bitmap>() {
                    @Override
                    public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                        // Procesa la imagen si se carga con éxito
                        processImage(resource, calculatedWidth, contenedor, image, imageUrl);
                        new Handler(Looper.getMainLooper()).postDelayed(() -> showImageSequentially(fileNames, index + 1, path, contenedor, carpeta), 80);
                    }

                    @Override
                    public void onLoadFailed(@Nullable Drawable errorDrawable) {
                        Log.e("GlideError", "Fallo al cargar la imagen desde: " + imageUrl);
                        if (currentRetry < maxRetriesAval) {
                            Log.d("GlideRetry", "Reintentando carga. Intento " + (currentRetry + 1) + " de " + maxRetries);
                            loadImageWithRetriesAval(imageUrl, calculatedWidth, contenedor, image, fileNames, index, path, carpeta, maxRetries, currentRetry + 1); // Reintenta la carga
                        } else {
                            Log.e("GlideError", "Todos los reintentos fallaron para la URL: " + imageUrl);
                        }
                    }
                });
    }


    private void processImage(Bitmap resource, int calculatedWidth, LinearLayoutCompat contenedor, ImageView image, String imageUrl) {
        int imageWidth = resource.getWidth();
        int imageHeight = resource.getHeight();
        int calculatedHeight = (int) ((float) imageHeight / imageWidth * calculatedWidth);

        LinearLayoutCompat.LayoutParams params = new LinearLayoutCompat.LayoutParams(calculatedWidth, calculatedHeight);
        params.setMargins(0, 0, 0, 15);

        image.setLayoutParams(params);
        image.setScaleType(ImageView.ScaleType.FIT_CENTER);
        image.setImageBitmap(resource);
        contenedor.addView(image);

        image.setOnClickListener(view -> {
            View dialogView = LayoutInflater.from(requireActivity()).inflate(R.layout.dialog_documento, null);
            TouchImageView touchImageView = dialogView.findViewById(R.id.imagen);
            Picasso.get()
                    .load(imageUrl)
                    .memoryPolicy(MemoryPolicy.NO_CACHE, MemoryPolicy.NO_STORE)
                    .networkPolicy(NetworkPolicy.NO_CACHE)
                    .into(touchImageView);

            new MaterialAlertDialogBuilder(getActivity())
                    .setTitle("")
                    .setView(dialogView)
                    .setCancelable(false)
                    .setPositiveButton("CERRAR", (dialogInterface, i) -> {
                        // Cierra el diálogo
                    })
                    .show();
        });
    }

    public void getFilesA(String carpeta, LinearLayoutCompat contenedor) {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        Log.d("ruta", "solo carpeta de aval:"+ carpeta);
        String path = API.url.replace("php/", "resources/");
        //String path = "https://sw.gruposefinsa.com/resources/";
        //String path = "https://gruposefinsa.com/test/resources/";
        String ruta = "../../resources/" + carpeta;
        Log.d("ruta", "RUTA COMPLETA............:"+ ruta);

        JSONObject data = new JSONObject();
        try {
            data.put("func", "archivos");
            data.put("ruta", ruta);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlAvales, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            dialog.cancel();
                            Log.d("data", String.valueOf(data));

                            if (!response.get("data").toString().equals("false")) {
                                JSONArray jsonArray = (JSONArray) response.get("data");
                                Log.d("archivos", jsonArray.length() + "");

                                // Crear una lista para almacenar los nombres de archivo
                                List<String> fileNames = new ArrayList<>();

                                for (int i = 2; i < jsonArray.length(); i++) {
                                    String fileName = jsonArray.getString(i);
                                    if (fileName.endsWith("9Expediente") || fileName.endsWith("9Thumbnail")) {
                                        Log.d("OMITIR", "Archivo omitido porque termina en 'T' o es una subcarpeta: " + fileName);
                                        continue; // Pasar al siguiente archivo
                                    }
                                    fileNames.add(jsonArray.getString(i));
                                }
                                Log.d("OMITIR", "Archivo en fileNames AVALES: " + fileNames);

                                // Mostrar imágenes una por una
                                showImageSequentiallyA(fileNames, 0, path, contenedor, carpeta);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, getActivity());
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    private void showImageSequentiallyA(List<String> fileNames, int index, String path, LinearLayoutCompat contenedor, String carpeta) {
        if (index >= fileNames.size()) return; // Salir si se ha mostrado todas las imágenes

        DisplayMetrics displayMetrics = new DisplayMetrics();
        getActivity().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int windowWidth = displayMetrics.widthPixels;

        float percentage = 0.85f;
        int calculatedWidth = (int) (windowWidth * percentage);
        String fileName = fileNames.get(index);

        // Crear el ImageView
        ImageView image = new ImageView(getActivity());
        String imageUrl = path + carpeta + "/" + fileName;

        String fileNameConE = "";
        if (fileName.contains(".")) {
            fileNameConE = fileName.substring(0, fileName.lastIndexOf(".")) + "E" + fileName.substring(fileName.lastIndexOf("."));
        } else {
            fileNameConE = fileName + "E";
        }

        String subcarpetaUrl = path + carpeta + "/9Expediente/" + fileNameConE;

        // Verifica solo la existencia de subcarpetaUrl
        checkIfImageExists(subcarpetaUrl, () -> {
            // Cargar la imagen desde subcarpetaUrl si existe
            Glide.with(getActivity())
                    .asBitmap()
                    .load(subcarpetaUrl)
                    .diskCacheStrategy(DiskCacheStrategy.NONE)
                    .skipMemoryCache(true)
                    .into(new SimpleTarget<Bitmap>() {
                        @Override
                        public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                            processImage(resource, calculatedWidth, contenedor, image, subcarpetaUrl);
                            new Handler(Looper.getMainLooper()).postDelayed(() -> showImageSequentiallyA(fileNames, index + 1, path, contenedor, carpeta), 80);
                        }

                        @Override
                        public void onLoadFailed(@Nullable Drawable errorDrawable) {
                            Log.e("GlideError", "No se pudo cargar la imagen desde la URL: " + subcarpetaUrl);
                        }
                    });
        }, () -> {
            // Si no existe en subcarpetaUrl, cargar directamente desde imageUrl
            loadImageWithRetriesAval(imageUrl, calculatedWidth, contenedor, image, fileNames, index, path, carpeta, maxRetries, 0);
        });
    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mViewModel = new ViewModelProvider(this).get(ClientesDocumentosViewModel.class);
        // TODO: Use the ViewModel
    }

}